 #ifndef _devcoons_STREAMING_H
	
	#define STREAMING_DEBUG
	
	#define _devcoons_STREAMING_H

	#define MAX_PACKET_DATA 14324

	#define STREAM_BUFFER_SIZE 150

	#include <queue>

	#include <time.h>

	#include <netdb.h>

	#include <iomanip>

	#include <float.h>

	#include <string.h>

	#include <unistd.h>
	
	#include <chrono>
#include <thread>
#include <mutex>

	#include <iostream>

	#include <pthread.h>

	#include <sys/types.h>

	#include <sys/types.h>

	#include <arpa/inet.h>

	#include <netinet/in.h>

	#include <sys/socket.h>

	#include "opencv2/opencv.hpp"

	#include "opencv2/core/core.hpp"

	#include "opencv2/highgui/highgui.hpp"

	using namespace std;
	
	using namespace cv;
	
	
	namespace devcoonsStreaming
	{

		typedef struct udp_message_t
		{
			char 	frame;
			char 	frames;
			int 	width;
			int 	height;
			char 	format;
			char 	command;
			char 	data[MAX_PACKET_DATA];
		}
		udp_message_t;


		typedef struct multimedia_config_t
		{
			int width;
			int height;
			int buffer;
			int frame_rate;
			char streaming_format;
			char video_source[256];
		}
		multimedia_config_t;


		// devcoons Streaming Library configurations

		extern int socket_id;

		extern sockaddr_in network_configuration;

		extern multimedia_config_t multimedia_configuration;


		// devcoons Streaming Global Variables

		extern socklen_t socket_length;

		extern pthread_t network_to_video_tid;

		extern std::queue<cv::Mat> frames;

		extern pthread_t video_to_frames_tid;

		extern pthread_t frames_to_network_tid;

		
		extern pthread_mutex_t active_mutex;
	
		extern VideoCapture video;
		
		extern std::mutex frames_mutex;
		
		extern	int thread_step;
			
		extern vector<std::thread> vectorOfThreads;

		// devcoons Streaming API for both client & server

		extern int Initialize(int);

		extern int Initialize(const char * ip_address, int port, int output_format, int output_width, int output_height, const char * video_source);

		extern void StartPlayback();

		extern void StartStreaming();

		extern void * NetworkToVideo(void *);

		extern void * VideoToFrames(void *);

		extern void * FramesToNetwork(void *);
		
		extern int BufferElements();
		
		void PushFrameToList(int);
		
		int BufferingThreads();
		
		void ImageFormatting(Mat *, Mat *);
		
		
	}

#endif
